/*
Copyright 2008-2011 Broadcom Corporation

This program isthe proprietary software of Broadcom Corporation and/or its
licensors, and may only be used, duplicated, modifiedor distributed pursuant to
the terms and conditions of a separate, written license agreement executed
between you and Broadcom (an "Authorized License"). Except as set forth in an
Authorized License, Broadcom grants no license (express or implied), right to
use, or waiver of any kind with respect to the Software, and Broadcom expressly
reserves all rights in and to the Software and all intellectual property rights
therein. IF YOU HAVE NO AUTHORIZED LICENSE, THEN YOU HAVE NO RIGHT TO USE THIS
SOFTWARE IN ANY WAY, AND SHOULD IMMEDIATELY NOTIFY BROADCOM AND DISCONTINUE ALL
USE OF THE SOFTWARE.

Except as expressly set forth in the Authorized License,

1. This program, including its structure, sequence and organization, constitutes
   the valuable trade secrets of Broadcom, and you shall use all reasonable
   efforts to protect the confidentiality thereof, and to use this information
   only in connection with your use of Broadcom integrated circuit products.

2.TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWAREIS PROVIDED "AS IS" AND
   WITH ALL FAULTS AND BROADCOM MAKES NO PROMISES, REPRESENTATIONS OR
   WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
   THE SOFTWARE.  BROADCOM SPECIFICALLY DISCLAIMSANY AND ALL IMPLIED WARRANTIES
   OF TITLE, MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE,
   LACK OF VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION
   OR CORRESPONDENCE TO DESCRIPTION. YOU ASSUME THE ENTIRE RISK ARISING OUT OF
   USE OR PERFORMANCE OF THE SOFTWARE.

3.TO THE MAXIMUM EXTENT PERMITTED BY LAW, IN NO EVENT SHALL BROADCOM OR ITS
   LICENSORS BE LIABLE FOR(i) CONSEQUENTIAL, INCIDENTAL, SPECIAL, INDIRECT, OR
   EXEMPLARY DAMAGES WHATSOEVER ARISING OUT OF OR IN ANY WAY RELATING TO YOUR
   USE OF OR INABILITY TO USE THE SOFTWARE EVEN IF BROADCOM HAS BEEN ADVISED OF
   THE POSSIBILITY OF SUCH DAMAGES; OR (ii) ANY AMOUNT IN EXCESS OF THE AMOUNT
   ACTUALLY PAID FOR THE SOFTWARE ITSELF OR U.S. $1, WHICHEVER IS GREATER. THESE
   LIMITATIONS SHALL APPLY NOTWITHSTANDING ANY FAILURE OF ESSENTIAL PURPOSE OF
   ANY LIMITED REMEDY.
*/


#ifndef KEYMGR_CRYPTO_H_
#define KEYMGR_CRYPTO_H_


/***************************************************
 *                 Public Defines Section
 ***************************************************/



/***************************************************
 *                 Public Constants Section
 ***************************************************/



/***************************************************
 *                 Public Typedefs Section
 ***************************************************/



/***************************************************
 *                 Local Constants Section
 ***************************************************/

/** \brief maximum length of the input password for NMK/DAK generation */
#define KEYMGR_MAX_PSW_SIZE   (64)
/** \brief minimum length of the input password NMK/DAK generation */
#define KEYMGR_MIN_PSW_SIZE   (12)

/** \brief iteration numbers for NMK generation using PBKDF1 */
#define KEYMGR_NMK_PBKDF1_N_ITER            (1000)
/** \brief iteration numbers for DAK generation using PBKDF1 */
#define KEYMGR_DAK_PBKDF1_N_ITER            (1000)
/** \brief iteration numbers for NID generation using PBKDF1 */
#define KEYMGR_NID_PBKDF1_N_ITER            (5)
/** \brief iteration numbers for AES key generation using PBKDF1 - used for GIGLE-defined MMs */
#define KEYMGR_GIGLE_KEY_PBKDF1_N_ITER      (99)
/** \brief iteration numbers for AES key generation using PBKDF1 - used for primitives */
#define KEYMGR_PRIMITIVE_KEY_PBKDF1_N_ITER  (100)

/** \brief size of the salt for PBKDF1 function */
#define KEYMGR_SALT_SIZE      (8)

/** \brief SHA-256 digest size */
#define SHA256_DIGEST_SIZE    (32) /* (256/8) */
/** \brief SHA-256 block size */
#define SHA256_BLOCK_SIZE     (64) /* (512/8) */

/** \brief maximum length of the HMAC secret key */
#define HASH_INPUT_SIZE       (SHA256_BLOCK_SIZE)


/***************************************************
 *                 Local Typedefs Section
 ***************************************************/

/** \brief SHA-256 context */
/* hold details of the current hash state */
typedef struct
{
  unsigned int tot_len; /**< count the byte size of the entire message */
  unsigned int len; /**< count how many bytes we have processed in the current block */
  unsigned char block[2 * SHA256_BLOCK_SIZE]; /**< internal buffer */
  unsigned int h[8];  /**< initial Hash value */
}
sha256_ctx;

/** \brief HMAC context */
typedef struct
{
  unsigned char key[HASH_INPUT_SIZE]; /**< secret key of the HMAC */
  sha256_ctx ctx[1];                  /**< SHA-256 context */
  unsigned long klen;                 /**< size of the sectre key */
}
hmac_ctx;


/***************************************************
 *                 Public Function Prototypes Section
 ***************************************************/

void KeymgrSha256(const unsigned char *message, unsigned int len,
    unsigned char *digest, sha256_ctx *ctx);
void KeymgrHmac(const unsigned char *key /* secret key*/, unsigned int key_len,
    const unsigned char *data /*counter*/, unsigned int data_len, unsigned char *mac,
    unsigned int mac_len);
void KeymgrPbkdf1Key(const unsigned char *pwd, unsigned int pwd_len,
    const unsigned char *salt, unsigned int salt_len,
    unsigned int iter, unsigned char *key, unsigned int key_len);

#endif

/*@}*/
